#!/usr/bin/env python
from __future__ import absolute_import, division, print_function
from future import standard_library
standard_library.install_aliases()
"""
A wrapper around Tkinter.Tk that puts up a separate Python
debugging window and then returns root. Optionally reads options
from a specified options file.

Instead of using an options file, you may wish to have a look
at the RO.Prefs module. It offers graphical editing of preferences
with live updating.

History:
2002-01-29 ROwen    Added code to allow global changing of fonts. This is a
    preliminary implementation, in that it doesn't mesh well with user
    setting of the option database, nor is there any other way to read
    in user defaults. Removed "from Tkinter import *".
2002-07-30 ROwen    Moved into the RO.Wdg module and renamed from ROStdTk.
2002-07-31 ROwen    Cleaned out a bunch of obsolete code.
2003-06-18 ROwen    Modified to test for StandardError instead of Exception
2004-05-18 ROwen    Stopped importing sys and tkFont since they weren't used.
2004-06-22 ROwen    Renamed ScriptTk->PythonTk to avoid confusion with ScriptWdg.
                    Modified to use renamed ScriptWindow->PythonWdg module.
2004-08-11 ROwen    Define __all__ to restrict import.
2004-09-14 ROwen    Modified import of Bindings to not import RO.Wdg.
2014-09-17 ROwen    Modified to test for Exception instead of StandardError 
"""
__all__ = ['PythonTk']

import tkinter
from . import Bindings
from . import PythonWdg

class PythonTk (tkinter.Tk):
    """Creates a Tkinter application with standard menus and such"""
    def __init__(self, **kargs):
        """Creates a new application with some standard menus and such
        Returns the root window, just like Tk()
        To use:
            import RO.Wdg
            myApp = RO.Wdg.PythonTk()
            # configure stuff here, e.g. creating new windows, etc.
            myApp.mainloop()

        Keyword arguments:
            All those for Tkinter.Tk(), plus:
            "optionfile": the full path name of an option file
        """

        # first parse PythonTk-specific options
        # but do not try to apply them yet if they require Tk to be initialized
        optionfile = None
        if kargs and "optionfile" in kargs:
            optionfile = kargs["optionfile"]
            del(kargs["optionfile"])

        # basic initialization
        tkinter.Tk.__init__(self, **kargs)
        
        # if the user supplied an option file, load it
        if optionfile:
            try:
                self.option_readfile(optionfile)
            except Exception as e:
                print("cannot read option file; error:", e)
        
        # create and display a Python script window
        self.pyToplevel = tkinter.Toplevel()
        self.pyToplevel.geometry("+0+450")
        self.pyToplevel.title("Python")
        pyFrame = PythonWdg.PythonWdg(self.pyToplevel)
        pyFrame.pack(expand=tkinter.YES, fill=tkinter.BOTH)
        
        # set up standard bindings
        Bindings.stdBindings(self)


if __name__ == "__main__":
    root = PythonTk()
    aText = tkinter.Text(root, width=30, height=2)
    aText.insert(tkinter.END, "some text to manipulate")
    aText.grid(row=0, column=0, sticky=tkinter.NSEW)
    anEntry = tkinter.Entry(root)
    anEntry.insert(0, "more text")
    anEntry.grid(row=1, column=0, sticky=tkinter.EW)
    root.grid_rowconfigure(0, weight=1)
    root.grid_columnconfigure(0, weight=1)
    root.mainloop()
