from builtins import range
from builtins import object
import logging
import socket
import time

import numpy as np

class ltemps(object):
    def __init__(self, actor, name,
                 loglevel=logging.INFO):

        self.actor = actor
        self.logger = logging.getLogger('ltemps')
        self.logger.setLevel(loglevel)

        self.EOL = '\n'
        
        self.host = self.actor.config.get('ltemps', 'host')
        self.port = int(self.actor.config.get('ltemps', 'port'))

    def start(self):
        pass

    def stop(self, cmd=None):
        pass

    def sendOneCommand(self, cmdStr, cmd=None):
        if cmd is None:
            cmd = self.actor.bcast

        fullCmd = "%s%s" % (cmdStr, self.EOL)
        self.logger.debug('sending %r', fullCmd)
        cmd.diag('text="sending %r"' % fullCmd)

        try:
            s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
            s.settimeout(1.0)
        except socket.error as e:
            cmd.warn('text="failed to create socket to ltemps: %s"' % (e))
            raise
 
        try:
            s.connect((self.host, self.port))
            s.sendall(fullCmd)
        except socket.error as e:
            cmd.warn('text="failed to create connect or send to ltemps: %s"' % (e))
            raise

        try:
            ret = s.recv(1024)
        except socket.error as e:
            cmd.warn('text="failed to read response from ltemps: %s"' % (e))
            raise

        self.logger.debug('received %r', ret)
        cmd.diag('text="received %r"' % ret)
        s.close()

        return ret

    def getTemps(self, cmd=None):
        temps = []
        cmdStr = 'KRDG? %s'

        controller = 'D'
        for probe in range(1,5):
            s = "%s%d" % (controller, probe)
            reply = self.sendOneCommand(cmdStr % s,
                                        cmd=cmd)

            try:
                temp = float(reply)
            except:
                temp = np.nan

            temps.append(temp)

        if cmd is not None:
            cmd.inform('ltemps=%s' % (','.join(["%g" % (t) for t in temps])))
            
        return temps

    def status(self, cmd=None):
        self.getTemps(cmd=cmd)
        
    def tempsCmd(self, cmdStr, cmd=None):
        if cmd is None:
            cmd = self.actor.bcast

        ret = self.sendOneCommand(cmdStr, cmd)
        return ret

