KeysDictionary("testa", (1, 6),
               Key('Text', String(), help='Stuff for humans'),
               # All cooler keys:
               Key("coolerLoop",
                   Enum("ON","OFF","POWER",
                        help="the state of the control loop"),
                   Float(invalid="NaN", name='P'),
                   Float(invalid="NaN", name='I'),
                   Float(invalid="NaN", name='D')),

               Key("coolerTemps",
                   Float(invalid="NaN", units="K", name='setpoint'),
                   Float(invalid="NaN", units="C", name='reject'),
                   Float(invalid="NaN", units="K", name='tip'),
                   Float(invalid="NaN", units="W", name='power'),
                   help="Cryocooler state. Setpoint, Reject, Tip."),

               # All ion gauge keywords
               Key("pressure", Float(invalid="NaN", units="Torr"),
                   help="Ion gauge pressure. Comes via PCM UDP."),
               Key("roughPressure1", Float(invalid="NaN", units="Torr"),
                   help="Roughing station 1 gauge pressure."),

               # # All ion pump keywords:
               # # Need to add:
               # #    The error bit masks and descriptions, current spat out as text
               Key("ionpump1",
                   Bool('0', '1', name='enabled'),
                   Float(name='Voltage', invalid="NaN", units="V"),
                   Float(name='Current', invalid="NaN", units="A"),
                   Float(name='Temperature', invalid="NaN", units="K"),
                   Float(name='Pressure', invalid="NaN", units="Torr"),
                   help="Ion pump status. Pump #1 for this dewar"),
               Key("ionpump2",
                   Bool('0', '1', name='enabled'),
                   Float(name='Voltage', invalid="NaN", units="V"),
                   Float(name='Current', invalid="NaN", units="A"),
                   Float(name='Temperature', invalid="NaN", units="K"),
                   Float(name='Pressure', invalid="NaN", units="Torr"),
                   help="Ion pump status. Pump #2 for this dewar"),

               # PCM keywords
               Key("powerNames", String()*8,
                   help="names of the PCM power port devices."),
               Key("powerMask", Int(),
                   help="mask of the powered PCM ports. 1=on"),
               Key("poweredUp", String()*(1,8),
                   help="convenience string naming the powered PCM ports"),
               Key("pcmPower",
                   Float("bus1", units='V'),
                   Float("bus2", units='V'),
                   help="input voltages for the two power busses"),

               # Temp & heater keywords
               #    Still need heater names, description of high power heaters.
               Key("temps", Float(invalid="NaN", units="K")*12,
                   help="Temperatures from the IDG board"),
               Key("tempNames", String(invalid="N/C")*12,
                   help="Names of the temperature probes on the IDG board"),
               Key("heaters",
                   Int(name='H1enabled', help='is heater 1 enabled'),
                   Int(name='H2enabled', help='is heater 2 enabled'),
                   Float(name='H1fraction', help='fractional power to heater 1. 0..1'),
                   Float(name='H2fraction', help='fractional power to heater 2, 0..1'),
                   help='status of the low power heaters.'),

               Key("gatevalve",
                   UInt(),
                   Enum('Open', 'Closed', 'Unknown', 'Invalid',
                        name='position', help='reported position'),
                   Enum('Open', 'Closed', 'Blocked', 'Invalid',
                        name='controlState', help='enabled by xcu, allowed by interlock'),
                   help='status of the gate valve'),

               Key("turboSpeed",
                   Int(units="rpm")),
               Key("turboStatus",
                   UInt(name="flags", reprFmt="0x%08x"),
                   String(name="description")),
               Key("turboVAW",
                   Float(invalid="NaN", units="V", name='voltage'),
                   Float(invalid="NaN", units="A", name='current'),
                   Float(invalid="NaN", units="W", name='power'),
                   help="Turbo pump draw. Use W, as A has useless resolution."),
               Key('turboTemps',
                   Float(invalid="NaN", units="degC", name='bodyTemp'),
                   Float(invalid="NaN", units="degC", name='controllerTemp')),

                # Motors:
               Key("ccdMotor1",
                    Enum('OK', 'Unknown', name='status'),
                    Int(invalid=-1, name='homeSwitch'),
                    Int(invalid=-1, name='farLimitSwitch'),
                    Int(invalid=0, units="steps", name='steps',
                        help="100 is defined to be the home position"),
                    Float(invalid="NaN", units="um", name='position',
                          help='arm vertex offset from home position'),
                    help="Motor 1: 12:00 facing visible dewar"),
               Key("ccdMotor2",
                    Enum('OK', 'Unknown', name='status'),
                    Int(invalid=-1, name='homeSwitch'),
                    Int(invalid=-1, name='farLimitSwitch'),
                    Int(invalid=0, units="steps", name='steps',
                        help="100 is defined to be the home position"),
                    Float(invalid="NaN", units="um", name='position',
                          help='arm vertex offset from home position'),
                    help="Motor 2: 4:00 facing visible dewar"),
               Key("ccdMotor3",
                    Enum('OK', 'Unknown', name='status'),
                    Int(invalid=-1, name='homeSwitch'),
                    Int(invalid=-1, name='farLimitSwitch'),
                    Int(invalid=0, units="steps", name='steps',
                        help="100 is defined to be the home position"),
                    Float(invalid="NaN", units="um", name='position',
                          help='arm vertex offset from home position'),
                    help="Motor 3: 8:00 facing visible dewar"),

               Key("pcmPort1",
                    String(name="name"),
                    String(name="state"),
                    Float(name="volts"),
                    Float(name="amps"),
                    Float(name="watts")),
               Key("pcmPort2",
                    String(name="name"),
                    String(name="state"),
                    Float(name="volts"),
                    Float(name="amps"),
                    Float(name="watts")),
               Key("pcmPort3",
                    String(name="name"),
                    String(name="state"),
                    Float(name="volts"),
                    Float(name="amps"),
                    Float(name="watts")),
               Key("pcmPort4",
                    String(name="name"),
                    String(name="state"),
                    Float(name="volts"),
                    Float(name="amps"),
                    Float(name="watts")),
               Key("pcmPort5",
                    String(name="name"),
                    String(name="state"),
                    Float(name="volts"),
                    Float(name="amps"),
                    Float(name="watts")),
               Key("pcmPort6",
                    String(name="name"),
                    String(name="state"),
                    Float(name="volts"),
                    Float(name="amps"),
                    Float(name="watts")),
               Key("pcmPort7",
                    String(name="name"),
                    String(name="state"),
                    Float(name="volts"),
                    Float(name="amps"),
                    Float(name="watts")),
               Key("pcmPort8",
                    String(name="name"),
                    String(name="state"),
                    Float(name="volts"),
                    Float(name="amps"),
                    Float(name="watts")),

)
